#include <cstdio>
#include <iostream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <string>
#include <cmath>
#include <map>
#include <set>
#include <climits>
#include <cassert>
#include <cctype>
using namespace std;

typedef long long ll;
typedef double dbl;
typedef long double ld;

#define mp make_pair
#define pb push_back
#define sz(x) (int)x.size()
#define all(x) x.begin(),x.end()
#define X first
#define Y second

const int maxn = 1000 * 100 + 1;
const dbl eps = (dbl)1e-6;
dbl x[maxn], rad[maxn];

bool emp(pair<dbl, dbl> a) {
	return a.X > a.Y;
}

bool is_equal(dbl a, dbl b) {
	return fabs(a - b) < eps;
}

bool is_more(dbl a, dbl b) {
	return !is_equal(a, b) && a > b;
}

int main() {
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	
	while (true) {
		int n;
		scanf("%d", &n);
		if (n == 0) break;
		for (int i = 0; i < n; i++)
			scanf("%lf%lf", &x[i], &rad[i]);
		dbl l = 0, r = 2*maxn;
		while (r - l > eps) {
			dbl mid = (r + l) / 2.;
			bool flag = false;
			vector< pair<dbl, dbl> > v;
			for (int i = 0; i < n; i++) {
				if (is_equal(rad[i] * rad[i] - mid * mid / 4, 0) || is_more(rad[i] * rad[i] - mid * mid / 4, 0)) {
					v.pb(mp(x[i] - sqrt(rad[i] * rad[i] - mid * mid / 4), x[i] + sqrt(rad[i] * rad[i] - mid * mid / 4)));
				}
			}

			if (sz(v) == 0) {
				r = mid;
				continue;
			}
			sort(all(v));
			pair<dbl, dbl> segm = v[0];
			if (is_more(v[0].Y - v[0].X, mid) || is_equal(v[0].Y - v[0].X, mid))
				flag = true;
			for (int i = 1; i < sz(v); i++) {
				if (flag) break;

				if (is_more(v[i].X, segm.Y)) segm = v[i];
				else segm.Y = max(segm.Y, v[i].Y);

				if (is_more(segm.Y - segm.X, mid) || is_equal(segm.Y - segm.X, mid))
					flag = true;
			}

			if (flag) l = mid;
			else r = mid;
		}
		printf("%.8lf\n", l);
	}
	
	return 0;
}